<?php $__env->startSection('adminlte_css_pre'); ?>
<link rel="stylesheet" href="<?php echo e(asset('vendor/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('adminlte_css'); ?>
<?php echo $__env->yieldPushContent('css'); ?>
<?php echo $__env->yieldContent('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('classes_body', 'login-page'); ?>

<?php ( $login_url = View::getSection('login_url') ?? config('adminlte.login_url', 'login') ); ?>
<?php ( $register_url = View::getSection('register_url') ?? config('adminlte.register_url', 'register') ); ?>
<?php ( $password_reset_url = View::getSection('password_reset_url') ?? config('adminlte.password_reset_url', 'password/reset') ); ?>
<?php ( $dashboard_url = View::getSection('dashboard_url') ?? config('adminlte.dashboard_url', 'home') ); ?>

<?php if(config('adminlte.use_route_url', false)): ?>
<?php ( $login_url = $login_url ? route($login_url) : '' ); ?>
<?php ( $register_url = $register_url ? route($register_url) : '' ); ?>
<?php ( $password_reset_url = $password_reset_url ? route($password_reset_url) : '' ); ?>
<?php ( $dashboard_url = $dashboard_url ? route($dashboard_url) : '' ); ?>
<?php else: ?>
<?php ( $login_url = $login_url ? url($login_url) : '' ); ?>
<?php ( $register_url = $register_url ? url($register_url) : '' ); ?>
<?php ( $password_reset_url = $password_reset_url ? url($password_reset_url) : '' ); ?>
<?php ( $dashboard_url = $dashboard_url ? url($dashboard_url) : '' ); ?>
<?php endif; ?>

<?php $__env->startSection('body'); ?>
<div class="login-box">
    <div class="login-logo">
        <a href="<?php echo e($dashboard_url); ?>"><?php echo config('adminlte.logo', '<b>Admin</b>LTE'); ?></a>
    </div>
    <div class="card">
        <div class="card-body login-card-body">
            <p class="login-box-msg"><?php echo e(__('adminlte::adminlte.login_message')); ?></p>
            <form action="<?php echo e($login_url); ?>" method="post">
                <?php echo e(csrf_field()); ?>

                <div class="input-group mb-3">
                    <input type="email" name="email" class="form-control <?php echo e($errors->has('email') ? 'is-invalid' : ''); ?>" value="<?php echo e(old('email')); ?>" placeholder="<?php echo e(__('adminlte::adminlte.email')); ?>" autofocus>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-envelope"></span>
                        </div>
                    </div>
                    <?php if($errors->has('email')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('email')); ?>

                    </div>
                    <?php endif; ?>
                </div>
                <div class="input-group mb-3">
                    <input type="password" name="password" class="form-control <?php echo e($errors->has('password') ? 'is-invalid' : ''); ?>" placeholder="<?php echo e(__('adminlte::adminlte.password')); ?>">
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-eye-slash" onclick="togglePasswordVisibility(this)"></span>
                        </div>
                    </div>
                    <?php if($errors->has('password')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('password')); ?>

                    </div>
                    <?php endif; ?>
                </div>
                <div class="row">
                    <div class="col-8">
                        <div class="icheck-primary">
                            <input type="checkbox" name="remember" id="remember">
                            <label for="remember"><?php echo e(__('adminlte::adminlte.remember_me')); ?></label>
                        </div>
                    </div>
                    <div class="col-4">
                        <button type="submit" class="btn btn-primary btn-block btn-flat">
                            <?php echo e(__('adminlte::adminlte.sign_in')); ?>

                        </button>
                    </div>
                </div>
            </form>
            <p class="mt-2 mb-1">
                <a href="<?php echo e($password_reset_url); ?>">
                    <?php echo e(__('adminlte::adminlte.i_forgot_my_password')); ?>

                </a>
            </p>
            <?php if($register_url): ?>
            <p class="mb-0">
                <a href="<?php echo e($register_url); ?>">
                    <?php echo e(__('adminlte::adminlte.register_a_new_membership')); ?>

                </a>
            </p>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('adminlte_js'); ?>
<script src="<?php echo e(asset('vendor/adminlte/dist/js/adminlte.min.js')); ?>"></script>
<?php echo $__env->yieldPushContent('js'); ?>
<?php echo $__env->yieldContent('js'); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/codecanyon/attendance-fingerprint-laravel/resources/views/vendor/adminlte/login.blade.php ENDPATH**/ ?>