<!-- page title -->
<?php $__env->startSection('title', 'Import Data ' . Config::get('adminlte.title')); ?>

<?php $__env->startSection('content_header'); ?>
<h1>Import Data</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php echo $__env->make('layouts.flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Import</h3>
    </div>

    <?php echo html()->form('POST', route($data->form_action))->attribute('autocomplete', 'off')->acceptsFiles()->open(); ?>

    <?php echo html()->hidden('id', $data->id)->id('id'); ?>


    <div class="card-body">

        <div class="form-group row">
            <div class="col-sm-2 col-form-label">
                <strong class="field-title">Import Data</strong>
            </div>
            <div class="col-sm-10 col-content">
                <?php echo html()->file('import')->class('custom-file-input')->id('import')->required(); ?>

                <?php echo html()->label('Choose file')->class('custom-file-label')->for('customFile'); ?>

                <span class="image-upload-label">Please upload the csv File</span>
            </div>
        </div>

        <div class="form-group row">
            <div class="col-sm-2 col-form-label">
                <strong class="field-title">Download Template</strong>
            </div>
            <div class="col-sm-10 col-content">
                <a href="<?php echo e(asset('img/template.csv')); ?>" download="">
                    <?php echo html()->button('Download Template CSV')->type('button')->class('btn btn-success'); ?>

                </a>
            </div>
        </div>

        <div class="form-group row">
            <div class="col-sm-2 col-form-label">
                <strong class="field-title">Instructions</strong>
            </div>
            <div class="col-sm-10 col-content">
                <?php echo html()->button('Show Instructions')->type('button')->class('btn btn-info collapsed')->attribute('data-toggle', 'collapse')->attribute('data-target', '#instructions')->attribute('aria-expanded', 'false'); ?>

                <div id="instructions" class="collapse col-content" aria-expanded="false">
                    <?php echo html()->img()->src(asset('img/import_csv.png'))->class('img-responsive'); ?>

                </div>
            </div>
        </div>

    </div>

    <div class="card-footer">
        <div id="form-button">
            <div class="col-sm-12 text-center top20">
                <?php echo html()->button($data->button_text)->type('submit')->name('submit')->id('btn-admin-member-submit')->class('btn btn-primary'); ?>

            </div>
        </div>
    </div>
    <?php echo html()->form()->close(); ?>

</div>

<!-- /.card -->
</div>
<!-- /.row -->
<!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    var typePage = "<?php echo e($data->page_type); ?>";
</script>

<script src="<?php echo e(asset('js/backend/histories/form.js'). '?v=' . rand(99999,999999)); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/codecanyon/attendance-fingerprint-laravel/resources/views/backend/users/import.blade.php ENDPATH**/ ?>