<?php $__env->startSection('title', 'Dashboard | ' . Config::get('adminlte.title')); ?>

<?php $__env->startSection('content_header'); ?>
<h1>Dashboard</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
        <?php if(session('status')): ?>
        <div class="alert alert-success" role="alert">
            <?php echo e(session('status')); ?>

        </div>
        <?php endif; ?>

        Hi <b><?php echo e(ucfirst(Auth::user()->name)); ?></b>, and Welcome! &#128513;
    </div>
</div>

<div class="row">
    <?php if(Auth::user()->hasRole('administrator')): ?>
    <div class="col-lg-3 col-6">
        <!-- small box -->
        <div class="small-box bg-warning">
            <div class="inner">
                <h3><?php echo e($userCount); ?></h3>

                <p>Total Users</p>
            </div>
            <div class="icon">
                <i class="fa fa-user-plus"></i>
            </div>
            <a href="<?php echo e(route('users')); ?>" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
        </div>
    </div>
    <?php endif; ?>

    <?php if(Auth::user()->hasRole('administrator')): ?>
    <div class="col-lg-3 col-6">
        <!-- small box -->
        <div class="small-box bg-danger">
            <div class="inner">
                <h3><?php echo e($attendanceLateToday); ?></h3>

                <p>Total Come late</p>
            </div>
            <div class="icon">
                <i class="fa fa-clock"></i>
            </div>
            <a href="<?php echo e(route('attendances')); ?>" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
        </div>
    </div>
    <?php endif; ?>

    <?php if(Auth::user()->hasRole('administrator')): ?>
    <div class="col-lg-3 col-6">
        <!-- small box -->
        <div class="small-box bg-primary">
            <div class="inner">
                <h3><?php echo e($attendaceToday); ?></h3>

                <p>Total Attendances</p>
            </div>
            <div class="icon">
                <i class="fa fa-database"></i>
            </div>
            <a href="<?php echo e(route('attendances')); ?>" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
        </div>
    </div>

    <div class="col-lg-3 col-6">
        <!-- small box -->
        <div class="small-box bg-gradient-gray">
            <div class="inner">
                <h3><?php echo e($areaCount); ?></h3>

                <p>Total Areas</p>
            </div>
            <div class="icon">
                <i class="fa fa-map-marked-alt"></i>
            </div>
            <a href="<?php echo e(route('areas')); ?>" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
        </div>
    </div>
    <?php endif; ?>
</div>

<div class="card card-default">
    <div class="card-header">
        <h3 class="card-title">
            <i class="fas fa-bullhorn"></i> Events this month!
        </h3>
    </div>

    <div class="card-body">
        <?php if(count($events) > 0): ?>
        <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="callout callout-info">
            <p>Date: <?php echo e($event->start_date->format('Y-m-d')); ?></p>
            <h5><?php echo e($event->title); ?></h5>
            <p><?php echo e($event->desc); ?></p>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
        <p>There is no Event this month.</p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/codecanyon/attendance-fingerprint-laravel/resources/views/home.blade.php ENDPATH**/ ?>