<?php

namespace KitLoong\MigrationsGenerator\Support;

class Regex
{
    /**
     * Get first occurred string between 2 tags.
     * Given: Hello, (this is (hot) chocolate).
     * Return: this is (hot
     *
     * @param  string  $text  Subject.
     * @param  string  $left  Left tag.
     * @param  string  $right  Right tag.
     */
    public static function getTextBetweenFirst(string $text, string $left = '\(', string $right = '\)'): ?string
    {
        $matched = preg_match('/' . $left . '(.*?)' . $right . '/', $text, $output);

        if ($matched === 1) {
            return $output[1];
        }

        return null;
    }

    /**
     * Get string between 2 tags.
     * Given: Hello, (this is (hot) chocolate).
     * Return: this is (hot) chocolate
     *
     * @param  string  $text  Subject.
     * @param  string  $left  Left tag.
     * @param  string  $right  Right tag.
     */
    public static function getTextBetween(string $text, string $left = '\(', string $right = '\)'): ?string
    {
        $matched = preg_match('/' . $left . '(.*)' . $right . '/', $text, $output);

        if ($matched === 1) {
            return $output[1];
        }

        return null;
    }

    /**
     * Get all strings between 2 tags.
     *
     * @param  string  $text  Subject.
     * @param  string  $left  Left tag.
     * @param  string  $right  Right tag.
     * @return string[]|null
     */
    public static function getTextBetweenAll(string $text, string $left = '\(', string $right = '\)'): ?array
    {
        $matched = preg_match_all('/' . $left . '(.*?)' . $right . '/', $text, $output);

        if ($matched > 0) {
            return $output[1];
        }

        return null;
    }
}
